// Autor: Gustav Matula

#include <cstdio>
#include <cstring>
#include <cstdlib>

#include <map>
#include <vector>
#include <algorithm>

using namespace std;
typedef long long llint;
const int inf = 1e9;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

const int MAX = 1005;

int a[MAX][MAX];

void solve() {
  int x1, y1; scanf("%d%d", &x1, &y1);
  int x2, y2; scanf("%d%d", &x2, &y2);

  vector< int > xs = { x1 - 1, x1, x1 + 1, x2 - 1, x2, x2 + 1 };
  vector< int > ys = { y1 - 1, y1, y1 + 1, y2 - 1, y2, y2 + 1 };

  map< pair< int, int >, int > id;
  int n = 0;

  for (int x : xs)
    for (int y : ys)
      if (!id.count({x, y}))
	id[{x, y}] = n++;

  REP(i, n) REP(j, n) a[i][j] = inf;
  REP(i, n) a[i][i] = 0;

  for (int x : xs)
    for (int y1 : ys)
      for (int y2 : ys)
	if ((x % 2 == 0) == (y1 < y2))
	  a[id[{x, y1}]][id[{x, y2}]] = abs(y1 - y2);

  for (int y : ys)
    for (int x1 : xs)
      for (int x2 : xs)
	if ((y % 2 == 0) == (x1 < x2))
	  a[id[{x1, y}]][id[{x2, y}]] = abs(x1 - x2);

  REP(k, n) REP(i, n) REP(j, n)
    a[i][j] = min(a[i][j], a[i][k] + a[k][j]);

  printf("%d\n", a[id[{x1, y1}]][id[{x2, y2}]]);
}

int main(void)
{
  int N;
  scanf("%d", &N);
  REP(i, N) solve();

  return 0;
}
